#ifndef LIST_H
#define LIST_H

#include<iostream.h>
#include<assert.h>
#include<fstream.h>

template <class T>

class List;

//-------------------------------- N O D E  C L A S S -----------------------------------

template <class T>

class Node
{
	friend class List<T>;

	public:
		Node()
		{
			next=NULL;
		}

		Node(const T &d)
		{
			data=d;
			next=NULL;
		}

		Node(const T &d, Node<T> *n)
		{
			data=d;
			next=n;
		}		

	private:
		T data;
		Node<T> *next;
};

//-------------------------------- L I S T  C L A S S --------------------------------------

template <class T>

class List
{
	public:
		List()
		{
			Head=NULL;
			Tail=NULL;
			size=0;
		}

		List(const List<T> &);
		~List();
		void Delete_List();
		void Insert_Node(const T &);
		void Delete_Node(const T &);
		void Display_List(ofstream &) const;

		int Get_size() const
		{
			return size;
		}

		List& operator = (const List<T> &);

	private:
		Node<T> *Head;
		Node<T> *Tail;

		int size;
};

template <class T>

List<T>::~List()
{
	Delete_List();
	size=0;
}

template <class T>

void List<T>::Delete_List()
{
	if (Head!=NULL)
	{
		Node<T> *currentptr=Head;
		Node<T> *tempptr;

		while (currentptr!=0)
		{
			tempptr=currentptr;
			currentptr=currentptr->next;			
			delete tempptr;
		}
	}	
	Head=NULL;
}

template <class T>

void List<T> :: Insert_Node(const T &value)
{
	Node<T> *newptr=new Node<T>(value);
	assert(newptr!=0);

	if (Head==0)
	{
		Head=newptr;
		Tail=newptr;
	}
	else
	{
		Tail->next=newptr;
		Tail=newptr;
	}
	size++;
}

template <class T>

void List<T> :: Delete_Node(const T &value)
{
	if (Head==0)
	{
		cout<<"\n error : THE LIST IS EMPTY !";
	}
	else
	{
		Node<T> *Fatherptr=Head;
		Node<T> *Sonptr=Head->next;

		if (Fatherptr->data==value)
		{
			Head=Head->next;
		}
		else
		{
			while (Sonptr!=NULL)
			{
				if (Sonptr->data==value)
				{
					Fatherptr->next=Sonptr->next;
				}	

				Sonptr=Sonptr->next;
				Fatherptr=Fatherptr->next;
			}
		}
	}
}

template <class T>

void List<T> :: Display_List(ofstream &outFile) const 
{
	if (Head==0)
		outFile<<"error : THE LIST IS EMPTY ! \n";

	else
	{
		Node<T> *currentptr=Head;

		outFile<<"\n\n -------------------------------------------";
		outFile<<"\n\tL I S T  C O N T E N T S ";
		outFile<<"\n -------------------------------------------\n";

		while (currentptr !=NULL)
		{
			outFile<<"\t\t"<<currentptr->data<<endl<<endl;
			currentptr=currentptr->next;
		}		
	}
}

template <class T>

List<T> :: List(const List<T> &original)
{
	size=original.size;

	Node<T> *ptr=original.Head;
	Node<T> *newptr , *lastptr;

	while(ptr!=NULL);
	{
		newptr=new Node<T>(ptr->data);
		assert(newptr!=0);

		if (Head==0)
			Head=newptr;
		else
			lastptr->next=newptr;

		lastptr=newptr;
		ptr=ptr->next;
	}
}

template <class T>

List<T>& List<T> :: operator=(const List<T> &original)
{
	if (this!=&original)
	{
		deleteList();

		size=original.size;
		Head=0;
		Node<T> *ptr=original.Head;
		Node<T> *newptr , *lastptr;

		while(ptr!=0);
		{
			newptr=new Node<T>(ptr->data);
			assert(newptr!=0);

			if (Head==0)
				Head=newptr;
			else
				lastptr->next=newptr;

			lastptr=newptr;
			ptr=ptr->next;
		}
	}
}

#endif

